/* globals window, document */

/**
 * Responsible for communicating Document events back to the Java runtime.
 */
(function(JavascriptDocumentEventHandler) {
    'use strict';

    function bindEventListeners() {
        document.addEventListener('DOMContentLoaded', function() {
            JavascriptDocumentEventHandler.handleDOMContentLoaded();
        });
    }

    // Export Globals
    window.documentEventBridge = {
        bindEventListeners: bindEventListeners
    };
})(window.JavascriptDocumentEventHandler);
